"""
数据获取服务
从 MySQL 数据库查询库销比等数据
"""

import logging
from typing import List, Optional
from datetime import date
from decimal import Decimal

from .db import get_connection
from ..models import PartRatio

logger = logging.getLogger(__name__)


class DataService:
    """数据服务"""

    def __init__(self):
        self._conn = None

    def _get_connection(self):
        """获取数据库连接"""
        if self._conn is None or not self._conn.is_connected():
            self._conn = get_connection()
        return self._conn

    def close(self):
        """关闭连接"""
        if self._conn and self._conn.is_connected():
            self._conn.close()
            self._conn = None



    def get_dealer_groupings(self, group_id: int) -> List[dict]:
        """
        获取商家组合列表
        
        Returns:
            [{"id": 1, "name": "商家组合A", "dealer_ids": [1, 2, 3]}]
        """
        conn = self._get_connection()
        cursor = conn.cursor(dictionary=True)

        try:
            sql = """
                SELECT id, region_name as name, auth_dealers
                FROM artificial_region_dealer
                WHERE group_id = %s
            """
            cursor.execute(sql, [group_id])
            rows = cursor.fetchall()

            result = []
            for row in rows:
                dealer_ids = []
                if row.get("auth_dealers"):
                    try:
                        import json
                        dealers = json.loads(row["auth_dealers"])
                        if isinstance(dealers, list):
                            if dealers and isinstance(dealers[0], dict):
                                dealer_ids = [d.get("dealerId") for d in dealers if d.get("dealerId")]
                            else:
                                dealer_ids = [int(d) for d in dealers if d]
                    except:
                        pass
                result.append({
                    "id": row["id"],
                    "name": row["name"],
                    "dealer_ids": dealer_ids,
                })

            logger.info(f"查询商家组合: group_id={group_id}, count={len(result)}")
            return result

        finally:
            cursor.close()











