"""
补货建议和配件分析结果模型
"""

from dataclasses import dataclass, field
from decimal import Decimal
from typing import List


@dataclass
class ReplenishmentSuggestion:
    """补货建议"""
    shop_id: int
    shop_name: str
    part_code: str
    part_name: str
    unit: str
    cost_price: Decimal
    current_storage_cnt: Decimal
    avg_sales_cnt: Decimal
    current_ratio: Decimal
    suggest_cnt: int
    suggest_amount: Decimal
    suggestion_reason: str
    priority: int = 2
    confidence: float = 0.8


@dataclass
class PartAnalysisResult:
    """配件分析结果 - 包含配件级汇总信息"""
    part_code: str
    part_name: str
    unit: str
    cost_price: Decimal
    total_storage_cnt: Decimal
    total_avg_sales_cnt: Decimal
    group_current_ratio: Decimal
    need_replenishment: bool
    total_suggest_cnt: int
    total_suggest_amount: Decimal
    shop_count: int
    need_replenishment_shop_count: int
    part_decision_reason: str
    priority: int = 2
    confidence: float = 0.8
    suggestions: List["ReplenishmentSuggestion"] = field(default_factory=list)
