"""
数据模型 - 配件汇总
"""

from dataclasses import dataclass
from decimal import Decimal
from datetime import datetime
from typing import Optional


@dataclass
class ReplenishmentPartSummary:
    """AI补货建议-配件汇总"""
    
    task_no: str
    group_id: int
    dealer_grouping_id: int
    part_code: str
    
    id: Optional[int] = None
    part_name: Optional[str] = None
    unit: Optional[str] = None
    cost_price: Decimal = Decimal("0")
    
    # 商家组合级别汇总数据
    total_storage_cnt: Decimal = Decimal("0")
    total_avg_sales_cnt: Decimal = Decimal("0")
    group_current_ratio: Optional[Decimal] = None
    
    # 补货建议汇总
    total_suggest_cnt: int = 0
    total_suggest_amount: Decimal = Decimal("0")
    shop_count: int = 0
    need_replenishment_shop_count: int = 0
    
    # LLM分析结果
    part_decision_reason: str = ""
    priority: int = 2
    llm_confidence: float = 0.8
    
    # 元数据
    statistics_date: str = ""
    create_time: Optional[datetime] = None

    def to_dict(self) -> dict:
        """转换为字典"""
        return {
            "task_no": self.task_no,
            "group_id": self.group_id,
            "dealer_grouping_id": self.dealer_grouping_id,
            "part_code": self.part_code,
            "part_name": self.part_name,
            "unit": self.unit,
            "cost_price": float(self.cost_price),
            "total_storage_cnt": float(self.total_storage_cnt),
            "total_avg_sales_cnt": float(self.total_avg_sales_cnt),
            "group_current_ratio": float(self.group_current_ratio) if self.group_current_ratio else None,
            "total_suggest_cnt": self.total_suggest_cnt,
            "total_suggest_amount": float(self.total_suggest_amount),
            "shop_count": self.shop_count,
            "need_replenishment_shop_count": self.need_replenishment_shop_count,
            "part_decision_reason": self.part_decision_reason,
            "priority": self.priority,
            "llm_confidence": self.llm_confidence,
            "statistics_date": self.statistics_date,
        }
