"""
任务执行日志模型和LLM建议明细模型
"""

from dataclasses import dataclass, field
from datetime import datetime
from decimal import Decimal
from typing import Optional
from enum import IntEnum


class LogStatus(IntEnum):
    """日志状态"""
    RUNNING = 0
    SUCCESS = 1
    FAILED = 2
    SKIPPED = 3


@dataclass
class TaskExecutionLog:
    """任务执行日志"""
    task_no: str
    group_id: int
    dealer_grouping_id: int
    step_name: str
    
    id: Optional[int] = None
    brand_grouping_id: Optional[int] = None
    brand_grouping_name: str = ""
    dealer_grouping_name: str = ""
    step_order: int = 0
    status: LogStatus = LogStatus.RUNNING
    input_data: str = ""
    output_data: str = ""
    error_message: str = ""
    retry_count: int = 0
    sql_query: str = ""
    llm_prompt: str = ""
    llm_response: str = ""
    llm_tokens: int = 0
    execution_time_ms: int = 0
    start_time: Optional[datetime] = None
    end_time: Optional[datetime] = None
    create_time: Optional[datetime] = None



