"""
数据模型 - 分析报告
四大板块：库存概览、销量分析、库存健康度、补货建议
"""

from dataclasses import dataclass, field
from datetime import datetime
from typing import Any, Dict, Optional


@dataclass
class AnalysisReport:
    """分析报告数据模型"""

    task_no: str
    group_id: int
    dealer_grouping_id: int

    id: Optional[int] = None
    dealer_grouping_name: Optional[str] = None
    brand_grouping_id: Optional[int] = None
    report_type: str = "replenishment"

    # 四大板块
    inventory_overview: Optional[Dict[str, Any]] = field(default=None)
    sales_analysis: Optional[Dict[str, Any]] = field(default=None)
    inventory_health: Optional[Dict[str, Any]] = field(default=None)
    replenishment_summary: Optional[Dict[str, Any]] = field(default=None)

    # LLM 元数据
    llm_provider: str = ""
    llm_model: str = ""
    llm_tokens: int = 0
    execution_time_ms: int = 0

    statistics_date: str = ""
    create_time: Optional[datetime] = None

    def to_dict(self) -> Dict[str, Any]:
        """将报告转换为可序列化的字典"""
        return {
            "id": self.id,
            "task_no": self.task_no,
            "group_id": self.group_id,
            "dealer_grouping_id": self.dealer_grouping_id,
            "dealer_grouping_name": self.dealer_grouping_name,
            "brand_grouping_id": self.brand_grouping_id,
            "report_type": self.report_type,
            "inventory_overview": self.inventory_overview,
            "sales_analysis": self.sales_analysis,
            "inventory_health": self.inventory_health,
            "replenishment_summary": self.replenishment_summary,
            "llm_provider": self.llm_provider,
            "llm_model": self.llm_model,
            "llm_tokens": self.llm_tokens,
            "execution_time_ms": self.execution_time_ms,
            "statistics_date": self.statistics_date,
            "create_time": self.create_time.isoformat() if self.create_time else None,
        }
