"""
fw-pms-ai 主入口
"""

import logging
import sys
from pathlib import Path

try:
    from .scheduler.tasks import main as scheduler_main
except ImportError:
    # 直接运行时,添加项目根目录到 sys.path
    project_root = Path(__file__).parent.parent.parent
    if str(project_root) not in sys.path:
        sys.path.insert(0, str(project_root))
    from fw_pms_ai.scheduler.tasks import main as scheduler_main


def main():
    """应用入口"""
    logging.basicConfig(
        level=logging.INFO,
        format="%(asctime)s [%(levelname)s] %(name)s: %(message)s",
    )
    
    scheduler_main()


if __name__ == "__main__":
    main()
