"""LLM 模块"""

from .base import BaseLLMClient, LLMResponse, LLMUsage
from .glm import GLMClient
from .doubao import DoubaoClient
from .anthropic_compat import AnthropicCompatClient
from .openai_compat import OpenAICompatClient
from ..config import get_settings


def get_llm_client() -> BaseLLMClient:
    """获取 LLM 客户端"""
    settings = get_settings()
    provider = settings.primary_llm_provider
    
    if provider == "openai_compat":
        return OpenAICompatClient()
    elif provider == "anthropic_compat":
        return AnthropicCompatClient()
    elif provider == "glm":
        return GLMClient()
    elif provider == "doubao":
        return DoubaoClient()
    else:
        raise ValueError(f"不支持的 LLM 供应商: {provider}")


__all__ = [
    "BaseLLMClient",
    "LLMResponse",
    "LLMUsage",
    "GLMClient",
    "DoubaoClient",
    "AnthropicCompatClient",
    "OpenAICompatClient",
    "get_llm_client",
]

