"""
提示词加载模块
"""

import os
import logging

logger = logging.getLogger(__name__)


def load_prompt(filename: str) -> str:
    """从prompts目录加载提示词文件"""
    # 从 src/fw_pms_ai/agent/sql_agent/prompts.py 向上5层到达项目根目录
    prompt_path = os.path.join(
        os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(__file__))))),
        "prompts", filename
    )
    try:
        with open(prompt_path, "r", encoding="utf-8") as f:
            return f.read()
    except FileNotFoundError:
        logger.warning(f"Prompt文件未找到: {prompt_path}")
        return ""


# 预加载常用提示词
SQL_AGENT_SYSTEM_PROMPT = load_prompt("sql_agent.md")
SUGGESTION_PROMPT = load_prompt("suggestion.md")
SUGGESTION_SYSTEM_PROMPT = load_prompt("suggestion_system.md")
PART_SHOP_ANALYSIS_PROMPT = load_prompt("part_shop_analysis.md")
PART_SHOP_ANALYSIS_SYSTEM_PROMPT = load_prompt("part_shop_analysis_system.md")
