-- ============================================================================
-- AI 补货建议分析报告表
-- ============================================================================
-- 版本: 3.0.0
-- 更新日期: 2026-02-10
-- 变更说明: 重构为四大数据驱动板块（库存概览/销量分析/健康度/补货建议）
-- ============================================================================

DROP TABLE IF EXISTS ai_analysis_report;
CREATE TABLE ai_analysis_report (
    id                   BIGINT AUTO_INCREMENT PRIMARY KEY COMMENT '主键ID',
    task_no              VARCHAR(32) NOT NULL COMMENT '任务编号',
    group_id             BIGINT NOT NULL COMMENT '集团ID',
    dealer_grouping_id   BIGINT NOT NULL COMMENT '商家组合ID',
    dealer_grouping_name VARCHAR(128) COMMENT '商家组合名称',
    brand_grouping_id    BIGINT COMMENT '品牌组合ID',
    report_type          VARCHAR(32) DEFAULT 'replenishment' COMMENT '报告类型',

    -- 四大板块 (JSON 结构化存储，每个字段包含 stats + llm_analysis)
    inventory_overview    JSON COMMENT '库存总体概览(统计数据+LLM分析)',
    sales_analysis        JSON COMMENT '销量分析(统计数据+LLM分析)',
    inventory_health      JSON COMMENT '库存构成健康度(统计数据+图表数据+LLM分析)',
    replenishment_summary JSON COMMENT '补货建议生成情况(统计数据+LLM分析)',

    -- LLM 元数据
    llm_provider         VARCHAR(32) COMMENT 'LLM提供商',
    llm_model            VARCHAR(64) COMMENT 'LLM模型名称',
    llm_tokens           INT DEFAULT 0 COMMENT 'LLM Token消耗',
    execution_time_ms    INT DEFAULT 0 COMMENT '执行耗时(毫秒)',

    statistics_date      VARCHAR(16) COMMENT '统计日期',
    create_time          DATETIME DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',

    INDEX idx_task_no (task_no),
    INDEX idx_group_date (group_id, statistics_date),
    INDEX idx_dealer_grouping (dealer_grouping_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='AI补货建议分析报告表-重构版';
