# 补货建议生成提示词

基于以下配件库销比数据，分析并生成补货建议。

---

## 商家组合信息

| 项目 | 数值 |
|------|------|
| 商家组合ID | {dealer_grouping_id} |
| 商家组合名称 | {dealer_grouping_name} |
| 统计日期 | {statistics_date} |

---

## 配件数据

{part_data}

---

## 字段说明

| 字段名 | 含义 | 计算公式/说明 |
|--------|------|---------------|
| valid_storage_cnt | 有效库存数量 | 在库未锁 + 在途 + 计划数 + 主动调拨在途 + 自动调拨在途 |
| avg_sales_cnt | 月均销量 | (90天出库数 + 未关单已锁 + 未关单出库 + 订件) / 3 |
| cost_price | 成本价 | 单件采购成本 |
| current_ratio | 当前库销比 | 有效库存 / 月均销量 |
| out_stock_cnt | 90天出库数量 | 用于判断呆滞件 |

---

## 业务术语定义

### 🚫 呆滞件（不补货）

- **判定条件**: `valid_storage_cnt > 0` 且 `out_stock_cnt = 0`
- **特征**: 有库存但90天无任何出库
- **处理**: 不做计划，应考虑清理

### 🚫 低频件（不补货）

- **判定条件**: `valid_storage_cnt = 0` 且 `avg_sales_cnt < 1`
- **特征**: 无库存且月均销量不足1件
- **处理**: 不做计划，需求过低

### ✅ 缺货件（优先补货）

- **判定条件**: `valid_storage_cnt = 0` 且 `avg_sales_cnt >= 1`
- **特征**: 无库存但有稳定需求
- **处理**: 高优先级补货

---

## 分析任务

请按以下步骤执行：

1. **识别并排除** 呆滞件和低频件（这些配件不应出现在输出中）
2. **逐个分析** 剩余配件的库存状况
3. **计算补货量** 使用公式: `建议数量 = ceil(目标库销比 × 月均销量 - 当前库存)`
4. **确定优先级** 基于库销比和销量水平
5. **撰写理由** 为每个建议提供数据支撑的决策依据

---

## 输出格式

直接输出JSON数组，**不要**包含 ```json 标记：

[
    {{
        "shop_id": 库房ID(整数),
        "shop_name": "库房名称",
        "part_code": "配件编码",
        "part_name": "配件名称",
        "unit": "单位",
        "cost_price": 成本价(数字),
        "current_storage_cnt": 当前库存(数字),
        "avg_sales_cnt": 月均销量(数字),
        "current_ratio": 当前库销比(数字),
        "suggest_cnt": 建议采购数量(整数),
        "suggest_amount": 建议采购金额(数字),
        "suggestion_reason": "详细的补货依据和决策理由",
        "priority": 优先级(1=高/2=中/3=低),
        "confidence": 置信度(0.0-1.0)
    }}
]

---

## 重要约束

1. **仅输出需要补货的配件**（suggest_cnt > 0）
2. **呆滞件和低频件不应出现在输出中**
3. **suggest_amount = suggest_cnt × cost_price**
4. **输出必须是合法的JSON数组**
