# 销量分析提示词

你是一位汽车配件销售数据分析师，擅长从销量数据中洞察需求趋势和业务机会。请基于以下销量统计数据，进行专业的销量分析。

---

## 统计数据

| 指标 | 数值 |
|------|------|
| 月均销量总数量 | {total_avg_sales_cnt} |
| 月均销量总金额 | {total_avg_sales_amount} 元 |
| 有销量配件数 | {has_sales_part_count} |
| 无销量配件数 | {no_sales_part_count} |

### 销量构成明细

| 构成项 | 数量 | 说明 |
|--------|------|------|
| 90天出库数 | {total_out_stock_cnt} | 近90天实际出库，反映正常销售 |
| 未关单已锁 | {total_storage_locked_cnt} | 已锁定库存但订单未关闭，反映待处理订单 |
| 未关单出库 | {total_out_stock_ongoing_cnt} | 已出库但订单未关闭，反映在途交付 |
| 订件 | {total_buy_cnt} | 客户预订的配件数量，反映预订需求 |

---

## 术语说明

- **月均销量**: (90天出库数 + 未关单已锁 + 未关单出库 + 订件) / 3
- **有销量配件**: 月均销量 > 0 的配件
- **无销量配件**: 月均销量 = 0 的配件
- **SKU活跃率**: 有销量配件数 / 总配件数 × 100%

---

## 当前季节信息

- **当前季节**: {current_season}
- **统计日期**: {statistics_date}

---

## 季节性因素参考

| 季节 | 销量特征 | 关注重点 |
|------|---------|---------|
| 春季(3-5月) | 销量逐步回升，保养类配件需求增加 | 关注机油、滤芯等保养件销量变化 |
| 夏季(6-8月) | 空调、冷却系统配件销量高峰 | 制冷配件销量应明显上升，否则需关注 |
| 秋季(9-11月) | 销量平稳，换季保养需求 | 轮胎、刹车片等安全件需求增加 |
| 冬季(12-2月) | 电瓶、暖风配件需求增加，春节前订单高峰 | 订件占比可能上升，属正常现象 |

---

## 分析框架与判断标准

### 销量构成健康标准
| 构成项 | 健康占比范围 | 异常信号 |
|--------|-------------|---------|
| 90天出库数 | > 70% | 占比过低说明正常销售不足，可能存在订单积压 |
| 未关单已锁 | < 15% | 占比过高说明订单处理效率低，需关注 |
| 未关单出库 | < 10% | 占比过高说明交付周期长，客户体验受影响 |
| 订件 | 5%-15% | 过高说明预订需求旺盛但库存不足，过低说明预订渠道不畅 |

### SKU活跃度判断标准
| 活跃率范围 | 判断等级 | 建议 |
|-----------|---------|------|
| > 80% | 优秀 | SKU管理良好，保持现状 |
| 70%-80% | 良好 | 可适当优化无销量SKU |
| 50%-70% | 一般 | 需要重点关注SKU精简 |
| < 50% | 较差 | SKU管理存在严重问题，需立即优化 |

### 需求趋势判断依据
| 信号 | 趋势判断 |
|------|---------|
| 订件占比上升 + 未关单占比上升 | 上升（需求增长但供应跟不上） |
| 90天出库占比稳定 + 各项占比均衡 | 稳定（供需平衡） |
| 90天出库占比下降 + 订件占比下降 | 下降（需求萎缩） |

---

## 分析任务

请严格按照以下步骤进行分析，每一步都要展示推理过程：

### 步骤1：计算关键指标
首先计算以下指标（请在分析中展示计算过程）：
- 各构成项占比 = 构成项数量 / (90天出库数 + 未关单已锁 + 未关单出库 + 订件) × 100%
- SKU活跃率 = 有销量配件数 / (有销量配件数 + 无销量配件数) × 100%
- 单件平均销售金额 = 月均销量总金额 / 月均销量总数量

### 步骤2：销量构成分析
- 对照健康标准，评估各构成项占比是否合理
- 识别主要销量来源
- 分析未关单（已锁+出库）对整体销量的影响

### 步骤3：SKU活跃度评估
- 对照活跃度标准，确定当前活跃率等级
- 分析无销量配件占比的业务影响
- 提出SKU优化方向

### 步骤4：季节性分析
- 结合当前季节特征，评估销量表现是否符合季节预期
- 分析季节性配件的销量是否正常

### 步骤5：需求趋势判断
- 根据各构成项的占比关系，判断需求趋势
- 结合季节因素，说明判断依据
- 给出短期需求预测（考虑季节变化）

---

## 输出格式

直接输出JSON对象，**不要**包含 ```json 标记：

{{
    "analysis_process": {{
        "calculated_metrics": {{
            "out_stock_ratio": "90天出库占比（计算过程：xxx / xxx = xx%）",
            "locked_ratio": "未关单已锁占比（计算过程）",
            "ongoing_ratio": "未关单出库占比（计算过程）",
            "buy_ratio": "订件占比（计算过程）",
            "sku_active_rate": "SKU活跃率（计算过程：xxx / xxx = xx%）",
            "avg_sales_price": "单件平均销售金额（计算过程）"
        }},
        "composition_diagnosis": {{
            "out_stock_evaluation": "90天出库占比评估（对照标准>70%，当前xx%，结论）",
            "locked_evaluation": "未关单已锁占比评估（对照标准<15%，当前xx%，结论）",
            "ongoing_evaluation": "未关单出库占比评估（对照标准<10%，当前xx%，结论）",
            "buy_evaluation": "订件占比评估（对照标准5%-15%，当前xx%，结论）",
            "abnormal_items": ["偏离健康范围的项目及原因分析"]
        }},
        "activity_diagnosis": {{
            "current_rate": "当前SKU活跃率",
            "level": "优秀/良好/一般/较差",
            "reasoning": "判断依据：对照标准xxx，当前值xxx，因此判断为xxx"
        }},
        "trend_diagnosis": {{
            "signals": ["观察到的趋势信号1", "观察到的趋势信号2"],
            "reasoning": "基于以上信号，判断需求趋势为xxx，因为xxx"
        }},
        "seasonal_analysis": {{
            "current_season": "当前季节",
            "expected_performance": "本季节预期销量特征",
            "actual_vs_expected": "实际表现与季节预期对比",
            "seasonal_items_status": "季节性配件销量状态评估"
        }}
    }},
    "conclusion": {{
        "composition_analysis": {{
            "main_driver": "主要销量来源分析（基于占比计算得出）",
            "pending_orders_impact": "未关单对销量的影响（基于占比计算得出）",
            "booking_trend": "订件趋势分析（基于占比计算得出）"
        }},
        "activity_assessment": {{
            "active_ratio": "活跃SKU占比评估结论",
            "optimization_suggestion": "SKU优化建议（基于活跃度等级给出）"
        }},
        "demand_trend": {{
            "direction": "上升/稳定/下降",
            "evidence": "判断依据（列出具体数据支撑）",
            "seasonal_factor": "季节因素对趋势的影响",
            "forecast": "短期需求预测（考虑季节变化）"
        }}
    }}
}}

---

## 重要约束

1. **输出必须是合法的JSON对象**
2. **分析必须基于提供的数据，不要编造数据**
3. **每个结论都必须有明确的推理依据和数据支撑**
4. **建议必须具体可操作，避免空泛的表述**
5. **direction 只能是"上升"、"稳定"、"下降"三个值之一**
6. **如果数据全为零，请在分析中说明无有效数据，并给出相应建议**
7. **所有百分比计算结果保留两位小数**
