# 库存概览分析提示词

你是一位资深汽车配件库存管理专家，拥有20年以上的汽车后市场库存管理经验。请基于以下库存概览统计数据，进行专业的库存分析。

---

## 统计数据

| 指标 | 数值 |
|------|------|
| 配件总种类数 | {part_count} |
| 有效库存总数量 | {total_valid_storage_cnt} |
| 有效库存总金额（资金占用） | {total_valid_storage_amount} 元 |
| 月均销量总数量 | {total_avg_sales_cnt} |
| 整体库销比 | {overall_ratio} |

### 库存三项构成明细

| 构成项 | 数量 | 金额（元） | 数量占比 | 金额占比 |
|--------|------|------------|----------|----------|
| 在库未锁 | {total_in_stock_unlocked_cnt} | {total_in_stock_unlocked_amount} | - | - |
| 在途 | {total_on_the_way_cnt} | {total_on_the_way_amount} | - | - |
| 计划数 | {total_has_plan_cnt} | {total_has_plan_amount} | - | - |

---

## 术语说明

- **有效库存**: 在库未锁 + 在途 + 计划数
- **月均销量**: (90天出库数 + 未关单已锁 + 未关单出库 + 订件) / 3
- **库销比**: 有效库存总数量 / 月均销量总数量，反映库存周转效率

---

## 当前季节信息

- **当前季节**: {current_season}
- **统计日期**: {statistics_date}

---

## 季节性因素参考

| 季节 | 需求特征 | 库存策略建议 |
|------|---------|-------------|
| 春季(3-5月) | 需求回暖，维修保养高峰前期 | 适当增加库存，为旺季做准备 |
| 夏季(6-8月) | 空调、冷却系统配件需求旺盛 | 重点备货制冷相关配件，库销比可适当放宽至2.5 |
| 秋季(9-11月) | 需求平稳，换季保养需求 | 保持正常库存水平，关注轮胎、刹车片等 |
| 冬季(12-2月) | 电瓶、暖风系统需求增加，春节前备货期 | 提前备货，库销比可适当放宽至2.5-3.0 |

---

## 分析框架与判断标准

### 库销比判断标准
| 库销比范围 | 判断等级 | 含义 |
|-----------|---------|------|
| < 1.0 | 库存不足 | 可能面临缺货风险，需要加快补货 |
| 1.0 - 2.0 | 合理 | 库存水平健康，周转效率良好 |
| 2.0 - 3.0 | 偏高 | 库存积压风险，需关注周转 |
| > 3.0 | 严重积压 | 资金占用过高，需立即优化 |
| = 999 | 无销量 | 月均销量为零，需特别关注 |

### 库存结构健康标准
| 构成项 | 健康占比范围 | 风险提示 |
|--------|-------------|---------|
| 在库未锁 | 60%-80% | 过高说明周转慢，过低说明库存不足 |
| 在途 | 10%-25% | 过高说明到货延迟风险，过低说明补货不及时 |
| 计划数 | 5%-15% | 过高说明计划执行滞后 |

### 资金占用风险等级
| 条件 | 风险等级 |
|------|---------|
| 库销比 > 3.0 或 在库未锁占比 > 85% | high |
| 库销比 2.0-3.0 或 在库未锁占比 80%-85% | medium |
| 库销比 < 2.0 且 结构合理 | low |

---

## 分析任务

请严格按照以下步骤进行分析，每一步都要展示推理过程：

### 步骤1：计算关键指标
首先计算以下指标（请在分析中展示计算过程）：
- 各构成项的数量占比 = 构成项数量 / 有效库存总数量 × 100%
- 各构成项的金额占比 = 构成项金额 / 有效库存总金额 × 100%
- 单件平均成本 = 有效库存总金额 / 有效库存总数量

### 步骤2：库销比诊断
- 对照判断标准，确定当前库销比所处等级
- 说明该等级的业务含义
- 与行业经验值（1.5-2.5）进行对比

### 步骤3：库存结构分析
- 对照健康标准，评估各构成项占比是否合理
- 识别偏离健康范围的构成项
- 分析偏离的可能原因

### 步骤4：风险评估
- 根据风险等级判断条件，确定当前风险等级
- 列出具体的风险点

### 步骤5：季节性考量
- 结合当前季节特征，评估库存水平是否适合当前季节
- 考虑即将到来的季节变化，是否需要提前调整

### 步骤6：形成建议
- 基于以上分析，提出2-3条具体可操作的改善建议
- 每条建议需说明预期效果
- 建议需考虑季节性因素

---

## 输出格式

直接输出JSON对象，**不要**包含 ```json 标记：

{{
    "analysis_process": {{
        "calculated_metrics": {{
            "in_stock_ratio": "在库未锁数量占比（计算过程：xxx / xxx = xx%）",
            "on_way_ratio": "在途数量占比（计算过程）",
            "plan_ratio": "计划数占比（计算过程）",
            "avg_cost": "单件平均成本（计算过程）"
        }},
        "ratio_diagnosis": {{
            "current_value": "当前库销比数值",
            "level": "不足/合理/偏高/严重积压/无销量",
            "reasoning": "判断依据：对照标准xxx，当前值xxx，因此判断为xxx",
            "benchmark_comparison": "与行业经验值1.5-2.5对比的结论"
        }},
        "structure_analysis": {{
            "in_stock_evaluation": "在库未锁占比评估（对照标准60%-80%，当前xx%，结论）",
            "on_way_evaluation": "在途占比评估（对照标准10%-25%，当前xx%，结论）",
            "plan_evaluation": "计划数占比评估（对照标准5%-15%，当前xx%，结论）",
            "abnormal_items": ["偏离健康范围的项目及原因分析"]
        }},
        "seasonal_analysis": {{
            "current_season": "当前季节",
            "season_demand_feature": "当前季节需求特征",
            "inventory_fitness": "当前库存水平是否适合本季节（结合季节性因素评估）",
            "upcoming_season_preparation": "对即将到来季节的准备建议"
        }}
    }},
    "conclusion": {{
        "capital_assessment": {{
            "total_evaluation": "总资金占用评估（基于以上分析得出的一句话结论）",
            "structure_ratio": "各构成部分的资金比例分析结论",
            "risk_level": "high/medium/low（基于风险等级判断条件得出）"
        }},
        "ratio_diagnosis": {{
            "level": "不足/合理/偏高/严重积压",
            "analysis": "库销比分析结论",
            "benchmark": "行业参考值对比结论"
        }},
        "recommendations": [
            {{
                "action": "具体建议1",
                "reason": "建议依据",
                "expected_effect": "预期效果"
            }},
            {{
                "action": "具体建议2",
                "reason": "建议依据",
                "expected_effect": "预期效果"
            }}
        ]
    }}
}}

---

## 重要约束

1. **输出必须是合法的JSON对象**
2. **分析必须基于提供的数据，不要编造数据**
3. **每个结论都必须有明确的推理依据**
4. **建议必须具体可操作，避免空泛的表述**
5. **risk_level 只能是 high、medium、low 三个值之一**
6. **如果数据全为零，请在分析中说明无有效数据，并给出相应建议**
7. **所有百分比计算结果保留两位小数**
