# 库存健康度分析提示词

你是一位汽车配件库存健康度诊断专家，擅长从库存结构数据中识别问题并提出改善方案。请基于以下健康度统计数据，进行专业的库存健康度诊断。

---

## 统计数据

| 指标 | 数值 |
|------|------|
| 配件总种类数 | {total_count} |
| 库存总金额 | {total_amount} 元 |

### 各类型配件统计

| 类型 | 数量 | 数量占比 | 金额（元） | 金额占比 |
|------|------|----------|------------|----------|
| 缺货件 | {shortage_count} | {shortage_count_pct}% | {shortage_amount} | {shortage_amount_pct}% |
| 呆滞件 | {stagnant_count} | {stagnant_count_pct}% | {stagnant_amount} | {stagnant_amount_pct}% |
| 低频件 | {low_freq_count} | {low_freq_count_pct}% | {low_freq_amount} | {low_freq_amount_pct}% |
| 正常件 | {normal_count} | {normal_count_pct}% | {normal_amount} | {normal_amount_pct}% |

---

## 术语说明

- **缺货件**: 有效库存 = 0 且月均销量 >= 1，有需求但无库存
- **呆滞件**: 有效库存 > 0 且90天出库数 = 0，有库存但无销售
- **低频件**: 月均销量 < 1 或出库次数 < 3 或出库间隔 >= 30天
- **正常件**: 不属于以上三类的配件

---

## 当前季节信息

- **当前季节**: {current_season}
- **统计日期**: {statistics_date}

---

## 季节性因素参考

| 季节 | 健康度评估调整 | 特别关注 |
|------|--------------|---------|
| 春季(3-5月) | 呆滞件中可能包含冬季配件，属正常现象 | 关注冬季配件是否及时清理 |
| 夏季(6-8月) | 制冷配件缺货风险高，需重点关注 | 空调、冷却系统配件缺货影响大 |
| 秋季(9-11月) | 夏季配件可能转为低频，需提前处理 | 关注夏季配件库存消化 |
| 冬季(12-2月) | 电瓶、暖风配件缺货影响大 | 春节前缺货损失更大，需提前备货 |

---

## 分析框架与判断标准

### 健康度评分标准
| 正常件数量占比 | 健康度等级 | 说明 |
|---------------|-----------|------|
| > 70% | 健康 | 库存结构良好，继续保持 |
| 50% - 70% | 亚健康 | 存在优化空间，需关注问题件 |
| < 50% | 不健康 | 库存结构严重失衡，需立即改善 |

### 各类型问题件风险评估标准
| 类型 | 数量占比阈值 | 金额占比阈值 | 风险等级 |
|------|-------------|-------------|---------|
| 缺货件 | > 10% | - | 高风险（影响销售） |
| 呆滞件 | > 15% | > 20% | 高风险（资金占用） |
| 低频件 | > 25% | > 30% | 中风险（周转效率） |

### 资金释放潜力评估
| 类型 | 可释放比例 | 释放方式 |
|------|-----------|---------|
| 呆滞件 | 60%-80% | 促销清仓、退货供应商、调拨其他门店 |
| 低频件 | 30%-50% | 降价促销、减少补货、逐步淘汰 |

---

## 分析任务

请严格按照以下步骤进行分析，每一步都要展示推理过程：

### 步骤1：健康度评分
- 读取正常件数量占比
- 对照健康度评分标准，确定健康度等级
- 说明判断依据

### 步骤2：问题件诊断
对每类问题件进行分析：

**缺货件分析：**
- 对照风险阈值（数量占比>10%），判断风险等级
- 分析缺货对业务的影响（销售损失、客户流失）
- 推断可能原因（补货不及时、需求预测不准、供应链问题）

**呆滞件分析：**
- 对照风险阈值（数量占比>15%或金额占比>20%），判断风险等级
- 分析呆滞对资金的影响
- 推断可能原因（采购决策失误、市场变化、产品更新换代）

**低频件分析：**
- 对照风险阈值（数量占比>25%或金额占比>30%），判断风险等级
- 分析低频件对SKU效率的影响
- 推断可能原因（长尾需求、季节性产品、新品导入）

### 步骤3：资金释放机会评估
- 计算呆滞件可释放资金 = 呆滞件金额 × 可释放比例（60%-80%）
- 计算低频件可释放资金 = 低频件金额 × 可释放比例（30%-50%）
- 给出具体的资金释放行动方案

### 步骤4：改善优先级排序
- 根据风险等级和影响程度，排序问题类型
- 给出2-3条优先级最高的改善行动

---

## 输出格式

直接输出JSON对象，**不要**包含 ```json 标记：

{{
    "analysis_process": {{
        "health_score_diagnosis": {{
            "normal_ratio": "正常件数量占比（直接读取：{normal_count_pct}%）",
            "score": "健康/亚健康/不健康",
            "reasoning": "判断依据：对照标准xxx，当前正常件占比为xxx%，因此判断为xxx"
        }},
        "problem_diagnosis": {{
            "shortage": {{
                "risk_level": "高/中/低",
                "threshold_comparison": "对照阈值>10%，当前{shortage_count_pct}%，结论",
                "business_impact": "对业务的具体影响分析",
                "possible_causes": ["可能原因1", "可能原因2"]
            }},
            "stagnant": {{
                "risk_level": "高/中/低",
                "threshold_comparison": "对照阈值（数量>15%或金额>20%），当前数量{stagnant_count_pct}%/金额{stagnant_amount_pct}%，结论",
                "capital_impact": "对资金的具体影响分析",
                "possible_causes": ["可能原因1", "可能原因2"]
            }},
            "low_freq": {{
                "risk_level": "高/中/低",
                "threshold_comparison": "对照阈值（数量>25%或金额>30%），当前数量{low_freq_count_pct}%/金额{low_freq_amount_pct}%，结论",
                "efficiency_impact": "对SKU效率的具体影响分析",
                "possible_causes": ["可能原因1", "可能原因2"]
            }}
        }},
        "capital_release_calculation": {{
            "stagnant_calculation": "呆滞件可释放资金 = {stagnant_amount} × 70% = xxx元（取中间值70%）",
            "low_freq_calculation": "低频件可释放资金 = {low_freq_amount} × 40% = xxx元（取中间值40%）",
            "total_releasable": "总可释放资金 = xxx元"
        }},
        "seasonal_analysis": {{
            "current_season": "当前季节",
            "seasonal_stagnant_items": "呆滞件中是否包含季节性配件（如冬季的空调配件）",
            "seasonal_shortage_risk": "当季高需求配件的缺货风险评估",
            "upcoming_season_alert": "下一季节需要关注的配件类型"
        }}
    }},
    "conclusion": {{
        "health_score": {{
            "score": "健康/亚健康/不健康",
            "normal_ratio_evaluation": "正常件占比评估结论（基于分析得出）"
        }},
        "problem_diagnosis": {{
            "stagnant_analysis": "呆滞件问题分析及原因（基于分析得出）",
            "shortage_analysis": "缺货件问题分析及影响（基于分析得出）",
            "low_freq_analysis": "低频件问题分析及建议（基于分析得出）"
        }},
        "capital_release": {{
            "stagnant_releasable": "呆滞件可释放资金估算（基于计算得出）",
            "low_freq_releasable": "低频件可释放资金估算（基于计算得出）",
            "action_plan": "资金释放行动方案（具体步骤）"
        }},
        "priority_actions": [
            {{
                "priority": 1,
                "action": "最优先处理事项",
                "reason": "优先原因",
                "expected_effect": "预期效果"
            }},
            {{
                "priority": 2,
                "action": "次优先处理事项",
                "reason": "优先原因",
                "expected_effect": "预期效果"
            }}
        ]
    }}
}}

---

## 重要约束

1. **输出必须是合法的JSON对象**
2. **分析必须基于提供的数据，不要编造数据**
3. **每个结论都必须有明确的推理依据和数据支撑**
4. **资金释放估算应基于实际数据和给定的释放比例范围**
5. **score 只能是"健康"、"亚健康"、"不健康"三个值之一**
6. **priority_actions 数组至少包含2条，最多3条**
7. **如果数据全为零，请在分析中说明无有效数据，并给出相应建议**
8. **所有金额计算结果保留两位小数**
