# 单配件多门店分析提示词

## 配件信息

- **配件编码**: {part_code}
- **配件名称**: {part_name}
- **成本价**: ¥{cost_price}
- **单位**: {unit}

## 商家组合

- **商家组合名称**: {dealer_grouping_name}
- **统计日期**: {statistics_date}
- **目标库销比**: {target_ratio}（基于商家组合计算的基准库销比，用于计算目标库存）

---

## 各门店数据

{shop_data}

## 字段说明

| 字段名 | 含义 | 用途 |
|--------|------|------|
| shop_id | 门店ID | 唯一标识 |
| shop_name | 门店名称 | 显示用 |
| valid_storage_cnt | 有效库存数量 | 当前可用库存 |
| avg_sales_cnt | 月均销量 | 基于90天销售数据计算 |
| out_stock_cnt | 90天出库数量 | 判断呆滞件的依据 |
| out_times | 90天内出库次数 | 判断低频件的依据（< 3次为低频件） |
| out_duration | 平均出库时长（天） | 最近两次出库间隔天数（≥ 30天为低频件） |
| current_ratio | 当前库销比 | = 有效库存 / 月均销量 |

---

## 分析任务

请按以下三层决策逻辑逐步分析：

### 1️⃣ 配件级判断（商家组合维度）
- 汇总所有门店的库存和销量，计算配件在商家组合内的整体库销比
- 判断该配件是否需要补货，需要补多少个
- 生成配件级决策理由

### 2️⃣ 门店级分配
- 将总补货数量分配到各门店
- 优先分配给库销比最低的门店
- 公式: suggest_cnt = ceil({target_ratio} × 月均销量 - 当前库存)

### 3️⃣ 为每个门店提供专业的决策理由

**理由必须包含以下要素**：
1. **状态判定标签**（括起来）：急需补货 / 建议补货 / 可选补货 / 库存充足 / 呆滞件 / 低频件-xxx
2. **关键指标数据**：当前库存X件、月均销量Y件、库销比Z
3. **缺口分析**（补货时）：目标库销比需备货A件，缺口B件
4. **天数说明**：当前库存可支撑约X天 / 补货后可支撑约Y天
5. **紧迫程度**：风险说明或建议优先级说明
6. **排除原因**（不补货时）：引用具体的排除规则数据

---

## 输出格式

直接输出JSON对象，**不要**包含 ```json 标记或任何其他文字：

{{
    "part_code": "{part_code}",
    "part_name": "{part_name}",
    "need_replenishment": true或false,
    "total_storage_cnt": 商家组合内总库存(数字),
    "total_avg_sales_cnt": 商家组合内总月均销量(数字),
    "group_current_ratio": 商家组合级库销比(数字，保留2位小数),
    "total_suggest_cnt": 所有门店建议数量之和,
    "total_suggest_amount": 所有门店建议金额之和,
    "part_decision_reason": "【配件决策】该配件在商家组合内总库存X件，月均总销量Y件，整体库销比Z。{{决策说明}}。该配件共涉及K家门店，其中J家门店需要补货。",
    "shop_count": 涉及门店总数(整数),
    "shop_suggestions": [
        {{
            "shop_id": 门店ID(整数),
            "shop_name": "门店名称",
            "current_storage_cnt": 当前库存(数字),
            "avg_sales_cnt": 月均销量(数字),
            "current_ratio": 当前库销比(数字，保留2位小数),
            "suggest_cnt": 建议采购数量(整数),
            "suggest_amount": 建议采购金额(数字),
            "priority": 优先级(1=高/2=中/3=低),
            "reason": "专业详尽的补货理由，包含关键数据指标（参见理由撰写规范）"
        }}
    ],
    "priority": 配件整体优先级(1=高/2=中/3=低),
    "confidence": 置信度(0.0-1.0)
}}

---

## 理由示例

### 补货理由示例：

**高优先级**：
```
「急需补货」当前库存0件，月均销量8.2件，库销比0.00，缺口分析：目标库销比{target_ratio}需备货X件，补货后可支撑约Y天销售。库存已告罄且销量活跃，存在严重缺货风险，建议立即补货。
```

**中优先级**：
```
「建议补货」当前库存2件，月均销量5.3件，库销比0.38，缺口分析：目标库销比{target_ratio}需备货X件，实际缺口Y件，补货后可支撑约Z天销售。当前库存仅够约11天销售，低于安全库销比0.5，建议尽快补货。
```

**低优先级**：
```
「可选补货」当前库存4件，月均销量3.5件，库销比1.14，优化建议：目标库销比{target_ratio}需备货X件，缺口Y件，补货后可支撑约Z天销售。库存处于安全边界，可根据资金情况酌情补货。
```

### 不补货理由示例：

**库存充足**：
```
「库存充足」当前库存8件，月均销量4.0件，库销比2.00，可支撑约60天销售，超过安全阈值（{target_ratio}个月），无需补货。
```

**低频件**：
```
「低频件-需求不足」当前库存0件，月均销量0.3件，月均销量不足1件（阈值≥1），周转需求过低，暂不纳入补货计划。
```

**呆滞件**：
```
「呆滞件」当前库存5件，但90天内无任何销售（月均销量0），库存滞销风险高，建议安排清理处置，暂不补货。
```

---

## 重要约束

1. **shop_suggestions 必须包含所有输入门店**，无论是否需要补货
2. **suggest_cnt = 0 的门店也必须返回**，并提供详细的不补货理由（如"库存充足"、"低频件"、"呆滞件"等）
3. **total_suggest_cnt 必须等于**所有门店 suggest_cnt 之和
4. **呆滞件/低频件的 suggest_cnt 必须为 0**
5. **低频件判定（满足任一即为低频件，不纳入补货）**：
   - `avg_sales_cnt < 1`: 月均销量 < 1
   - `out_times < 3`：90天内出库次数不足3次
   - `out_duration >= 30`：平均出库时长 ≥ 30天
6. **输出必须是合法的JSON**，可被直接解析
7. **理由必须专业详尽**，包含具体数据指标，贴合采购人员专业度
