# 商家组合维度分析报告 - 需求分析与设计文档

> **版本**: 2.0.0  
> **日期**: 2026-02-12  
> **项目**: fw-pms-ai（AI配件补货建议系统）

---

## 1. 业务背景与目标

### 1.1 业务痛点

汽车配件管理面临以下核心挑战：

| 痛点 | 描述 | 影响 |
|------|------|------|
| **库存失衡** | 部分配件长期缺货，部分配件严重呆滞 | 缺货导致客户流失，呆滞占用资金 |
| **人工决策低效** | 传统补货依赖采购员经验判断 | 效率低、易出错、难以规模化 |
| **多门店协调困难** | 同一商家组合下的多门店库存无法统一调配 | 资源利用率低，部分门店过剩而另一部分缺货 |
| **数据利用不足** | 丰富的销售数据未能有效转化为决策依据 | 补货缺乏数据支撑，决策质量参差不齐 |

### 1.2 项目目标

```mermaid
mindmap
  root((商家组合维度分析))
    智能补货建议
      LLM驱动分析
      配件级决策
      门店级分配
    风险识别与预警
      呆滞件识别
      低频件过滤
      缺货预警
    数据驱动分析报告
      库存概览
      销量分析
      库存健康度
      补货建议汇总
    可视化展示
      分析报告
      配件明细
      执行日志
```

**核心价值主张**：
1. **智能化**：通过 LLM 自动分析库销比数据，生成专业补货建议
2. **精细化**：从商家组合维度统一分析，再下钻到配件级、门店级
3. **专业化**：输出的分析理由贴合采购人员专业度，包含具体数据指标

---

## 2. 功能模块设计

### 2.1 功能架构

```mermaid
flowchart TB
    subgraph 用户层["🖥️ 用户层"]
        UI[Web管理界面]
    end
    
    subgraph 应用层["⚙️ 应用层"]
        API[FastAPI 接口层]
        
        subgraph Agent["🤖 LangGraph Agent"]
            N1[获取配件库销比<br/>fetch_part_ratio]
            N2[LLM分析生成建议<br/>sql_agent]
            N3[转换补货明细<br/>allocate_budget]
            N4[生成分析报告<br/>generate_analysis_report]
        end
        
        subgraph ReportSubgraph["📊 分析报告并发子图"]
            R1[库存概览 LLM]
            R2[销量分析 LLM]
            R3[健康度 LLM]
            R4[补货建议 LLM]
        end
    end
    
    subgraph 基础设施["🔧 基础设施"]
        LLM[LLM服务<br/>智谱GLM/豆包/OpenAI/Anthropic]
        DB[(MySQL数据库)]
    end
    
    UI --> API
    API --> Agent
    N1 --> N2 --> N3 --> N4
    N4 --> ReportSubgraph
    N1 -.-> DB
    N2 -.-> LLM
    N3 -.-> DB
    R1 & R2 & R3 & R4 -.-> LLM
```

### 2.2 功能模块清单

| 模块 | 功能 | 输入 | 输出 |
|------|------|------|------|
| **数据获取** | 获取商家组合内所有配件的库销比数据 | dealer_grouping_id | part_ratios[] |
| **LLM分析** | 按配件分组分析，生成补货建议和决策理由 | part_ratios, base_ratio | llm_suggestions[] |
| **建议转换** | 将LLM建议转换为结构化的补货明细 | llm_suggestions[] | details[], part_summaries[] |
| **分析报告** | 四大板块统计计算 + 并发LLM分析 | part_ratios, part_results | analysis_report |

---

## 3. 系统架构设计

### 3.1 整体架构

```mermaid
C4Component
    title 商家组合维度分析系统 - 组件架构

    Container_Boundary(web, "Web层") {
        Component(ui, "前端UI", "HTML/CSS/JS", "任务管理、结果展示")
    }
    
    Container_Boundary(api, "API层") {
        Component(routes, "路由模块", "FastAPI", "REST API接口")
        Component(scheduler, "定时调度", "APScheduler", "任务调度")
    }
    
    Container_Boundary(agent, "Agent层") {
        Component(workflow, "工作流引擎", "LangGraph", "状态机编排")
        Component(nodes, "节点实现", "Python", "业务逻辑")
        Component(report_subgraph, "报告子图", "LangGraph 并发子图", "4路并发LLM分析")
        Component(prompts, "提示词", "Markdown", "LLM指令")
    }
    
    Container_Boundary(service, "服务层") {
        Component(data, "数据服务", "Python", "数据查询")
        Component(writer, "写入服务", "Python", "结果持久化")
    }
    
    Container_Boundary(infra, "基础设施") {
        ComponentDb(mysql, "MySQL", "数据库", "业务数据存储")
        Component(llm, "LLM", "GLM/Doubao/OpenAI/Anthropic", "大语言模型")
    }
    
    Rel(ui, routes, "HTTP请求")
    Rel(routes, workflow, "触发任务")
    Rel(workflow, nodes, "执行")
    Rel(nodes, report_subgraph, "fan-out/fan-in")
    Rel(nodes, prompts, "加载")
    Rel(nodes, llm, "调用")
    Rel(nodes, data, "查询")
    Rel(nodes, writer, "写入")
    Rel(data, mysql, "SQL")
    Rel(writer, mysql, "SQL")
```

### 3.2 工作流状态机

```mermaid
stateDiagram-v2
    [*] --> FetchPartRatio: 启动任务
    
    FetchPartRatio --> SQLAgent: 获取库销比数据
    FetchPartRatio --> [*]: 无数据
    
    SQLAgent --> SQLAgent: 重试(错误 & 次数<3)
    SQLAgent --> AllocateBudget: 分析完成
    SQLAgent --> [*]: 重试失败
    
    AllocateBudget --> GenerateReport: 转换完成
    
    GenerateReport --> [*]: 生成报告
    
    state GenerateReport {
        [*] --> 统计计算
        统计计算 --> 并发LLM子图
        
        state 并发LLM子图 {
            [*] --> 库存概览LLM
            [*] --> 销量分析LLM
            [*] --> 健康度LLM
            [*] --> 补货建议LLM
            库存概览LLM --> [*]
            销量分析LLM --> [*]
            健康度LLM --> [*]
            补货建议LLM --> [*]
        }
        
        并发LLM子图 --> 汇总写入
        汇总写入 --> [*]
    }
```

---

## 4. 核心算法说明

### 4.1 三层决策逻辑

```mermaid
flowchart LR
    subgraph L1["第一层: 配件级判断"]
        A1[汇总商家组合内<br/>所有门店数据]
        A2[计算整体库销比]
        A3{是否需要补货?}
        A4[生成配件级理由]
    end
    
    subgraph L2["第二层: 门店级分配"]
        B1[按库销比从低到高排序]
        B2[计算各门店缺口]
        B3[分配补货数量]
    end
    
    subgraph L3["第三层: 决策理由生成"]
        C1[状态判定标签]
        C2[关键指标数据]
        C3[缺口分析]
        C4[天数说明]
    end
    
    A1 --> A2 --> A3
    A3 -->|是| L2
    A3 -->|否| A4
    B1 --> B2 --> B3
    B3 --> L3
    C1 --> C2 --> C3 --> C4
```

### 4.2 补货数量计算公式

```
suggest_cnt = ceil(目标库销比 × 月均销量 - 当前库存)
```

其中：
- **有效库存** = `in_stock_unlocked_cnt` + `on_the_way_cnt` + `has_plan_cnt`
- **月均销量** = (`out_stock_cnt` + `storage_locked_cnt` + `out_stock_ongoing_cnt` + `buy_cnt`) / 3
- **资金占用** = (`in_stock_unlocked_cnt` + `on_the_way_cnt`) × `cost_price`

### 4.3 配件分类与处理规则

| 分类 | 判定条件 | 处理策略 |
|------|----------|----------|
| **缺货件** | 有效库存 = 0 且 月均销量 ≥ 1 | 优先补货 |
| **呆滞件** | 有效库存 > 0 且 90天出库数 = 0 | 不补货，建议清理 |
| **低频件** | 月均销量 < 1 或 出库次数 < 3 或 出库间隔 ≥ 30天 | 不补货 |
| **正常件** | 不属于以上三类 | 按缺口补货 |

> 分类优先级：缺货件 > 呆滞件 > 低频件 > 正常件（按顺序判断，命中即止）

### 4.4 优先级判定标准

```mermaid
flowchart TD
    A{库存状态} -->|库存=0 且 销量活跃| H[高优先级<br/>急需补货]
    A -->|库销比<0.5| M[中优先级<br/>建议补货]
    A -->|0.5≤库销比<目标值| L[低优先级<br/>可选补货]
    A -->|库销比≥目标值| N[无需补货<br/>库存充足]
    
    style H fill:#ff6b6b
    style M fill:#feca57
    style L fill:#48dbfb
    style N fill:#2ecc71
```

---

## 5. 数据模型设计

### 5.1 ER图

```mermaid
erDiagram
    AI_REPLENISHMENT_TASK ||--o{ AI_REPLENISHMENT_DETAIL : contains
    AI_REPLENISHMENT_TASK ||--o{ AI_REPLENISHMENT_PART_SUMMARY : contains
    AI_REPLENISHMENT_TASK ||--o{ AI_TASK_EXECUTION_LOG : logs
    AI_REPLENISHMENT_TASK ||--o| AI_ANALYSIS_REPORT : generates
    PART_RATIO }o--|| AI_REPLENISHMENT_DETAIL : references
    
    AI_REPLENISHMENT_TASK {
        bigint id PK
        varchar task_no UK "AI-开头"
        bigint group_id "集团ID"
        bigint dealer_grouping_id
        varchar dealer_grouping_name
        bigint brand_grouping_id "品牌组合ID"
        decimal plan_amount "计划采购金额"
        decimal actual_amount "实际分配金额"
        int part_count "配件数量"
        decimal base_ratio "基准库销比"
        tinyint status "0运行/1成功/2失败"
        varchar llm_provider
        varchar llm_model
        int llm_total_tokens
        varchar statistics_date
        datetime start_time
        datetime end_time
    }
    
    AI_REPLENISHMENT_DETAIL {
        bigint id PK
        varchar task_no FK
        bigint group_id
        bigint dealer_grouping_id
        bigint brand_grouping_id
        bigint shop_id "库房ID"
        varchar shop_name
        varchar part_code "配件编码"
        varchar part_name
        varchar unit
        decimal cost_price
        decimal current_ratio "当前库销比"
        decimal base_ratio "基准库销比"
        decimal post_plan_ratio "计划后库销比"
        decimal valid_storage_cnt "有效库存"
        decimal avg_sales_cnt "月均销量"
        int suggest_cnt "建议数量"
        decimal suggest_amount "建议金额"
        text suggestion_reason "决策理由"
        int priority "1高/2中/3低"
        float llm_confidence "LLM置信度"
    }
    
    AI_REPLENISHMENT_PART_SUMMARY {
        bigint id PK
        varchar task_no FK
        bigint group_id
        bigint dealer_grouping_id
        varchar part_code "配件编码"
        varchar part_name
        varchar unit
        decimal cost_price
        decimal total_storage_cnt "总库存"
        decimal total_avg_sales_cnt "总月均销量"
        decimal group_current_ratio "商家组合库销比"
        int total_suggest_cnt "总建议数量"
        decimal total_suggest_amount "总建议金额"
        int shop_count "涉及门店数"
        int need_replenishment_shop_count "需补货门店数"
        text part_decision_reason "配件级理由"
        int priority "1高/2中/3低"
        float llm_confidence
    }
    
    AI_TASK_EXECUTION_LOG {
        bigint id PK
        varchar task_no FK
        bigint group_id
        bigint brand_grouping_id
        varchar brand_grouping_name
        bigint dealer_grouping_id
        varchar dealer_grouping_name
        varchar step_name "步骤名称"
        int step_order "步骤顺序"
        tinyint status "0进行/1成功/2失败/3跳过"
        text input_data "输入JSON"
        text output_data "输出JSON"
        text error_message
        int retry_count
        text sql_query
        text llm_prompt
        text llm_response
        int llm_tokens "Token消耗"
        int execution_time_ms "耗时"
    }
    
    AI_ANALYSIS_REPORT {
        bigint id PK
        varchar task_no FK
        bigint group_id
        bigint dealer_grouping_id
        varchar dealer_grouping_name
        bigint brand_grouping_id
        varchar report_type "默认replenishment"
        json inventory_overview "库存概览"
        json sales_analysis "销量分析"
        json inventory_health "健康度"
        json replenishment_summary "补货建议"
        varchar llm_provider
        varchar llm_model
        int llm_tokens
        int execution_time_ms
    }
    
    PART_RATIO {
        bigint id PK
        bigint shop_id
        varchar part_code
        decimal in_stock_unlocked_cnt "在库未锁定"
        decimal on_the_way_cnt "在途"
        decimal has_plan_cnt "已有计划"
        decimal out_stock_cnt "出库数"
        decimal storage_locked_cnt "库存锁定"
        decimal out_stock_ongoing_cnt "出库在途"
        decimal buy_cnt "采购数"
        decimal cost_price "成本价"
        int out_times "出库次数"
        int out_duration "平均出库间隔"
    }
```

### 5.2 核心表结构

#### ai_replenishment_task（任务主表）
| 字段 | 类型 | 说明 |
|------|------|------|
| task_no | VARCHAR(32) | 任务编号，AI-开头，唯一 |
| group_id | BIGINT | 集团ID |
| dealer_grouping_id | BIGINT | 商家组合ID |
| dealer_grouping_name | VARCHAR(128) | 商家组合名称 |
| brand_grouping_id | BIGINT | 品牌组合ID |
| plan_amount | DECIMAL(14,2) | 计划采购金额(预算) |
| actual_amount | DECIMAL(14,2) | 实际分配金额 |
| part_count | INT | 配件数量 |
| base_ratio | DECIMAL(10,4) | 基准库销比 |
| status | TINYINT | 状态: 0运行中/1成功/2失败 |
| llm_provider | VARCHAR(32) | LLM提供商 |
| llm_model | VARCHAR(64) | LLM模型名称 |
| statistics_date | VARCHAR(16) | 统计日期 |
| start_time / end_time | DATETIME | 任务执行起止时间 |

#### ai_replenishment_part_summary（配件汇总表）
| 字段 | 类型 | 说明 |
|------|------|------|
| task_no | VARCHAR(32) | 任务编号 |
| group_id | BIGINT | 集团ID |
| dealer_grouping_id | BIGINT | 商家组合ID |
| part_code | VARCHAR(64) | 配件编码 |
| part_name | VARCHAR(256) | 配件名称 |
| cost_price | DECIMAL(14,2) | 成本价 |
| total_storage_cnt | DECIMAL(14,2) | 商家组合内总库存 |
| total_avg_sales_cnt | DECIMAL(14,2) | 总月均销量 |
| group_current_ratio | DECIMAL(10,4) | 商家组合级库销比 |
| total_suggest_cnt | INT | 总建议数量 |
| total_suggest_amount | DECIMAL(14,2) | 总建议金额 |
| shop_count | INT | 涉及门店数 |
| need_replenishment_shop_count | INT | 需补货门店数 |
| part_decision_reason | TEXT | 配件级补货理由 |
| priority | INT | 优先级: 1高/2中/3低 |

#### ai_analysis_report（分析报告表）
| 字段 | 类型 | 说明 |
|------|------|------|
| task_no | VARCHAR(32) | 任务编号 |
| group_id | BIGINT | 集团ID |
| dealer_grouping_id | BIGINT | 商家组合ID |
| report_type | VARCHAR(32) | 报告类型(默认 replenishment) |
| inventory_overview | JSON | 库存总体概览(stats + llm_analysis) |
| sales_analysis | JSON | 销量分析(stats + llm_analysis) |
| inventory_health | JSON | 库存健康度(stats + chart_data + llm_analysis) |
| replenishment_summary | JSON | 补货建议(stats + llm_analysis) |
| llm_provider | VARCHAR(32) | LLM提供商 |
| llm_model | VARCHAR(64) | LLM模型名称 |
| llm_tokens | INT | LLM Token总消耗 |
| execution_time_ms | INT | 执行耗时(毫秒) |

---

## 6. API 接口设计

### 6.1 接口总览

```mermaid
flowchart LR
    subgraph Tasks["任务管理"]
        T1["GET /api/tasks"]
        T2["GET /api/tasks/:task_no"]
    end
    
    subgraph Details["明细查询"]
        D1["GET /api/tasks/:task_no/details"]
        D2["GET /api/tasks/:task_no/part-summaries"]
        D3["GET /api/tasks/:task_no/parts/:part_code/shops"]
    end
    
    subgraph Reports["报告模块"]
        R1["GET /api/tasks/:task_no/analysis-report"]
        R2["GET /api/tasks/:task_no/logs"]
    end
    
    subgraph Health["健康检查"]
        H1["GET /health"]
    end
```

### 6.2 核心接口定义

#### 1. 获取任务列表
```
GET /api/tasks?page=1&page_size=20&status=1&dealer_grouping_id=100&statistics_date=20260212
```

**响应示例**：
```json
{
  "items": [
    {
      "id": 1,
      "task_no": "AI-ABC12345",
      "group_id": 2,
      "dealer_grouping_id": 100,
      "dealer_grouping_name": "华东区商家组合",
      "brand_grouping_id": 50,
      "plan_amount": 100000.00,
      "actual_amount": 89520.50,
      "part_count": 156,
      "base_ratio": 1.5000,
      "status": 1,
      "status_text": "成功",
      "llm_provider": "openai_compat",
      "llm_model": "glm-4-7-251222",
      "llm_total_tokens": 8500,
      "statistics_date": "20260212",
      "start_time": "2026-02-12 02:00:00",
      "end_time": "2026-02-12 02:05:30",
      "duration_seconds": 330,
      "create_time": "2026-02-12 02:00:00"
    }
  ],
  "total": 100,
  "page": 1,
  "page_size": 20
}
```

#### 2. 获取配件汇总（商家组合维度）
```
GET /api/tasks/{task_no}/part-summaries?sort_by=total_suggest_amount&sort_order=desc&priority=1
```

**响应示例**：
```json
{
  "items": [
    {
      "id": 1,
      "task_no": "AI-ABC12345",
      "part_code": "C211F280503",
      "part_name": "机油滤芯",
      "unit": "个",
      "cost_price": 140.00,
      "total_storage_cnt": 25,
      "total_avg_sales_cnt": 18.5,
      "group_current_ratio": 1.35,
      "group_post_plan_ratio": 2.0,
      "total_suggest_cnt": 12,
      "total_suggest_amount": 1680.00,
      "shop_count": 5,
      "need_replenishment_shop_count": 3,
      "part_decision_reason": "【配件决策】该配件在商家组合内总库存25件...",
      "priority": 1,
      "llm_confidence": 0.85
    }
  ],
  "total": 50,
  "page": 1,
  "page_size": 50
}
```

#### 3. 获取门店级明细
```
GET /api/tasks/{task_no}/parts/{part_code}/shops
```

**响应示例**：
```json
{
  "total": 3,
  "items": [
    {
      "id": 101,
      "task_no": "AI-ABC12345",
      "shop_id": 1001,
      "shop_name": "杭州西湖店",
      "part_code": "C211F280503",
      "part_name": "机油滤芯",
      "cost_price": 140.00,
      "valid_storage_cnt": 5,
      "avg_sales_cnt": 6.2,
      "current_ratio": 0.81,
      "post_plan_ratio": 1.61,
      "suggest_cnt": 5,
      "suggest_amount": 700.00,
      "suggestion_reason": "「建议补货」当前库存5件，月均销量6.2件...",
      "priority": 1
    }
  ]
}
```

#### 4. 获取配件建议明细
```
GET /api/tasks/{task_no}/details?page=1&page_size=50&sort_by=suggest_amount&sort_order=desc&part_code=C211
```

#### 5. 获取分析报告
```
GET /api/tasks/{task_no}/analysis-report
```

**响应示例**：
```json
{
  "id": 1,
  "task_no": "AI-ABC12345",
  "group_id": 2,
  "dealer_grouping_id": 100,
  "report_type": "replenishment",
  "inventory_overview": {
    "stats": {
      "total_valid_storage_cnt": 2500,
      "total_valid_storage_amount": 350000.0,
      "total_capital_occupation": 280000.0,
      "overall_ratio": 1.35,
      "part_count": 156
    },
    "llm_analysis": { "..." : "LLM生成的分析结论" }
  },
  "sales_analysis": {
    "stats": { "total_avg_sales_cnt": 1850, "..." : "..." },
    "llm_analysis": { "..." : "..." }
  },
  "inventory_health": {
    "stats": { "shortage": { "count": 12, "amount": 5000 }, "..." : "..." },
    "chart_data": { "labels": ["缺货件","呆滞件","低频件","正常件"], "..." : "..." },
    "llm_analysis": { "..." : "..." }
  },
  "replenishment_summary": {
    "stats": { "urgent": { "count": 15, "amount": 25000 }, "..." : "..." },
    "llm_analysis": { "..." : "..." }
  },
  "llm_tokens": 3200,
  "execution_time_ms": 12000
}
```

#### 6. 获取执行日志
```
GET /api/tasks/{task_no}/logs
```

---

## 7. 前端交互设计

### 7.1 页面结构

```mermaid
flowchart TB
    subgraph Dashboard["仪表盘"]
        S1[统计卡片]
        S2[最近任务列表]
    end
    
    subgraph TaskList["任务列表页"]
        L1[筛选条件]
        L2[任务表格]
        L3[分页控件]
    end
    
    subgraph TaskDetail["任务详情页"]
        D1[任务头部信息]
        D2[统计卡片]
        
        subgraph Tabs["标签页"]
            T1[配件明细]
            T2[分析报告]
            T3[执行日志]
            T4[任务信息]
        end
    end
    
    Dashboard --> TaskList --> TaskDetail
```

### 7.2 配件明细交互

```mermaid
sequenceDiagram
    participant U as 用户
    participant UI as 前端UI
    participant API as 后端API
    
    U->>UI: 点击任务详情
    UI->>API: GET /api/tasks/{task_no}/part-summaries
    API-->>UI: 返回配件汇总列表
    UI->>UI: 渲染配件表格(可排序/筛选/优先级)
    
    U->>UI: 点击展开某配件
    UI->>API: GET /api/tasks/{task_no}/parts/{part_code}/shops
    API-->>UI: 返回门店级明细
    UI->>UI: 展开子表格显示门店数据
    
    Note over UI: 门店数据包含：<br/>库存、销量、库销比<br/>建议数量、建议理由<br/>计划后库销比
```

### 7.3 关键UI组件

| 组件 | 功能 | 交互方式 |
|------|------|----------|
| **配件汇总表格** | 展示商家组合维度的配件建议 | 支持排序、筛选、分页、优先级筛选 |
| **可展开行** | 展示配件下的门店明细 | 点击行展开/收起 |
| **配件决策卡片** | 显示LLM生成的配件级理由 | 展开配件时显示 |
| **库销比指示器** | 直观显示库销比健康度 | 颜色渐变(红/黄/绿) |
| **分析报告面板** | 四大板块数据驱动展示 | 统计数据 + LLM 分析 + 图表 |

---

## 8. 分析报告设计

### 8.1 报告模块结构

分析报告由 **统计计算** + **4路并发 LLM 分析** 的 LangGraph 子图生成。每个板块包含 `stats`（统计数据）和 `llm_analysis`（LLM 分析结论）。

```mermaid
flowchart TB
    subgraph Report["分析报告四大板块"]
        M1["板块1: 库存总体概览<br/>inventory_overview"]
        M2["板块2: 销量分析<br/>sales_analysis"]
        M3["板块3: 库存构成健康度<br/>inventory_health"]
        M4["板块4: 补货建议生成情况<br/>replenishment_summary"]
    end
    
    M1 --> S1[有效库存/资金占用]
    M1 --> S2[在库/在途/已有计划]
    M1 --> S3[整体库销比]
    
    M2 --> R1[月均销量/销售金额]
    M2 --> R2[有销量/无销量配件数]
    M2 --> R3[出库/锁定/采购统计]
    
    M3 --> P1[缺货件统计]
    M3 --> P2[呆滞件统计]
    M3 --> P3[低频件统计]
    M3 --> P4[正常件统计]
    M3 --> P5[chart_data图表数据]
    
    M4 --> E1[急需补货统计]
    M4 --> E2[建议补货统计]
    M4 --> E3[可选补货统计]
```

### 8.2 各板块统计计算与LLM分析

| 板块 | 统计计算 | LLM 分析 | 提示词文件 |
|------|---------|---------|-----------|
| **库存概览** | 有效库存、资金占用、配件总数、整体库销比 | 库存状况综合评价 | `report_inventory_overview.md` |
| **销量分析** | 月均销量、出库频次、有/无销量配件数 | 销售趋势洞察 | `report_sales_analysis.md` |
| **库存健康度** | 缺货/呆滞/低频/正常分类统计(数量/金额/占比) | 健康度风险提示 | `report_inventory_health.md` |
| **补货建议汇总** | 按优先级(急需/建议/可选)分类统计 | 补货策略建议 | `report_replenishment_summary.md` |

> 四个 LLM 分析节点使用 LangGraph 子图 **并发执行**（fan-out / fan-in），单板块失败不影响其他板块。

### 8.3 并发子图实现

```mermaid
flowchart LR
    START --> A[库存概览LLM] --> END2[END]
    START --> B[销量分析LLM] --> END2
    START --> C[健康度LLM] --> END2
    START --> D[补货建议LLM] --> END2
```

子图采用 `ReportLLMState` TypedDict 定义状态，使用 `Annotated` reducer 合并并发结果：
- 分析结果：`_merge_dict`（保留非 None）
- Token 用量：`_sum_int`（累加）

---

## 9. 技术选型

| 组件 | 技术 | 选型理由 |
|------|------|----------|
| **编程语言** | Python 3.11+ | 丰富的AI/ML生态 |
| **Agent框架** | LangChain + LangGraph | 成熟的LLM编排框架，支持并发子图 |
| **API框架** | FastAPI | 高性能、自动文档 |
| **数据库** | MySQL | 与主系统保持一致 |
| **LLM** | 智谱GLM / 豆包 / OpenAI兼容 / Anthropic兼容 | 多模型支持，优先级自动选择 |
| **前端** | 原生HTML+CSS+JS | 轻量级，无构建依赖 |

### LLM 客户端优先级

| 优先级 | 客户端 | 触发条件 |
|--------|--------|----------|
| 1 | `OpenAICompatClient` | `OPENAI_COMPAT_API_KEY` 已配置 |
| 2 | `AnthropicCompatClient` | `ANTHROPIC_API_KEY` 已配置 |
| 3 | `GLMClient` | `GLM_API_KEY` 已配置 |
| 4 | `DoubaoClient` | `DOUBAO_API_KEY` 已配置 |

---

## 10. 部署与运维

### 10.1 部署架构

```mermaid
flowchart LR
    subgraph Client["客户端"]
        Browser[浏览器]
    end
    
    subgraph Server["服务器"]
        Nginx[Nginx<br/>静态资源/反向代理]
        API[FastAPI<br/>API服务]
        Scheduler[APScheduler<br/>定时任务]
    end
    
    subgraph External["外部服务"]
        LLM[LLM API]
        DB[(MySQL)]
    end
    
    Browser --> Nginx
    Nginx --> API
    API --> LLM
    API --> DB
    Scheduler --> API
```

### 10.2 关键监控指标

| 指标 | 阈值 | 告警方式 |
|------|------|----------|
| 任务成功率 | < 95% | 邮件 |
| LLM响应时间 | > 30s | 日志 |
| Token消耗 | > 10000/任务 | 日志 |
| API响应时间 | > 2s | 监控 |

---

## 附录

### A. 术语表

| 术语 | 定义 |
|------|------|
| 商家组合 | 多个经销商/门店的逻辑分组 |
| 库销比 | 库存数量 / 月均销量，衡量库存健康度 |
| 呆滞件 | 有库存但90天无出库数的配件 |
| 低频件 | 月均销量<1 或 出库次数<3 或 出库间隔≥30天的配件 |
| 有效库存 | 在库未锁定 + 在途 + 已有计划 |
| 资金占用 | (在库未锁定 + 在途) × 成本价 |

### B. 参考文档

- [docs/architecture.md](file:///Users/gunieason/Studio/Code/FeeWee/fw-pms-ai/docs/architecture.md) - 系统架构文档
- [prompts/part_shop_analysis.md](file:///Users/gunieason/Studio/Code/FeeWee/fw-pms-ai/prompts/part_shop_analysis.md) - 配件分析提示词
- [prompts/report_inventory_overview.md](file:///Users/gunieason/Studio/Code/FeeWee/fw-pms-ai/prompts/report_inventory_overview.md) - 库存概览提示词
- [prompts/report_sales_analysis.md](file:///Users/gunieason/Studio/Code/FeeWee/fw-pms-ai/prompts/report_sales_analysis.md) - 销量分析提示词
- [prompts/report_inventory_health.md](file:///Users/gunieason/Studio/Code/FeeWee/fw-pms-ai/prompts/report_inventory_health.md) - 库存健康度提示词
- [prompts/report_replenishment_summary.md](file:///Users/gunieason/Studio/Code/FeeWee/fw-pms-ai/prompts/report_replenishment_summary.md) - 补货建议提示词

### C. 版本变更记录

| 版本 | 日期 | 变更说明 |
|------|------|----------|
| 1.0.0 | 2026-02-09 | 初始版本 |
| 2.0.0 | 2026-02-12 | 根据实际实现更新：分析报告重构为四大数据驱动板块、ER图更新、API路径和字段对齐、新增LLM客户端等 |
