# fw-pms-ai

fw-pms 配件管理系统 AI 扩展平台 — 基于 Python + LangChain + LangGraph

## 项目简介

本项目是 `fw-pms` 配件管理系统的 **AI 能力扩展平台**，使用大语言模型 (LLM) 和 Agent 技术，为配件业务提供多种智能化功能。

### 功能模块

| 状态 | 模块 | 说明 |
|------|------|------|
| ✅ 已实现 | **智能补货建议** | 分析库销比数据，LLM 逐配件分析各门店补货需求，生成结构化建议 |
| ✅ 已实现 | **分析报告** | 四大板块（库存概览/销量分析/健康度/补货建议）并发 LLM 分析 |
| 🚧 规划中 | **需求预测** | 基于历史销量预测未来配件需求 |
| 🚧 规划中 | **异常检测** | 识别库存和销量数据异常 |
| 🚧 规划中 | **智能定价** | AI 辅助配件定价建议 |

## 技术栈

| 组件 | 技术 | 版本要求 |
|------|------|---------|
| 编程语言 | Python | ≥ 3.11 |
| Agent 框架 | LangChain + LangGraph | LangChain ≥ 0.3, LangGraph ≥ 0.2 |
| LLM 集成 | 智谱 GLM / 豆包 / OpenAI 兼容 / Anthropic 兼容 | — |
| Web API | FastAPI + Uvicorn | FastAPI ≥ 0.109 |
| 数据库 | MySQL (mysql-connector-python + SQLAlchemy) | SQLAlchemy ≥ 2.0 |
| 任务调度 | APScheduler | ≥ 3.10 |
| 配置管理 | Pydantic Settings + python-dotenv | Pydantic ≥ 2.0 |
| HTTP 客户端 | httpx | ≥ 0.25 |
| 重试机制 | tenacity | ≥ 8.0 |

## 系统架构

```mermaid
flowchart TB
    subgraph Scheduler ["定时调度 (APScheduler)"]
        S[每日凌晨触发]
    end

    subgraph API ["FastAPI API 层"]
        A[/tasks, details, logs, reports/]
    end

    subgraph Agent ["LangGraph 工作流"]
        direction TB
        B[1. fetch_part_ratio] --> C[2. sql_agent]
        C --> D{需要重试?}
        D -->|是| C
        D -->|否| E[3. allocate_budget]
        E --> F[4. generate_analysis_report]
        F --> G[END]
    end

    subgraph ReportSubgraph ["分析报告并发子图"]
        direction LR
        R1[库存概览 LLM] & R2[销量分析 LLM] & R3[健康度 LLM] & R4[补货建议 LLM]
    end

    subgraph Services ["业务服务层"]
        DS[DataService]
        RW[ResultWriter]
        RP[Repository]
    end

    subgraph LLM ["LLM 适配层"]
        L1[GLMClient]
        L2[DoubaoClient]
        L3[OpenAICompatClient]
        L4[AnthropicCompatClient]
    end

    subgraph DB ["数据存储"]
        MySQL[(MySQL)]
    end

    S --> Agent
    A --> Services
    B --> DS
    C --> LLM
    F --> ReportSubgraph
    ReportSubgraph --> LLM
    E --> RW
    DS --> MySQL
    RW --> MySQL
    RP --> MySQL
```

详细架构图见 [docs/architecture.md](docs/architecture.md)

> 平台采用模块化设计，新增 AI 功能模块只需添加对应的 Agent 工作流节点和提示词文件。

## 补货建议工作流

补货建议模块的核心是一个 **4 节点 LangGraph 工作流**，按顺序执行：

| 序号 | 节点 | 功能 | 说明 |
|------|------|------|------|
| 1 | `fetch_part_ratio` | 获取库销比数据 | 通过 dealer_grouping_id 从 part_ratio 表查询配件数据 |
| 2 | `sql_agent` | LLM 分析 + 建议生成 | 按 part_code 分组，逐配件分析各门店补货需求，支持错误重试 |
| 3 | `allocate_budget` | 转换补货明细 | 将 LLM 建议转换为结构化的补货明细记录 |
| 4 | `generate_analysis_report` | 生成分析报告 | 统计计算 + 4 路并发 LLM 分析生成结构化报告 |

### 分析报告四大板块

| 板块 | 统计计算 | LLM 分析 |
|------|---------|---------|
| **库存概览** | 有效库存、资金占用、配件总数 | 库存状况综合评价 |
| **销量分析** | 月均销量、出库频次、销售趋势 | 销售趋势洞察 |
| **库存健康度** | 缺货/呆滞/低频/正常分类统计 | 健康度风险提示 |
| **补货建议汇总** | 按优先级分类统计补货数量和金额 | 补货策略建议 |

> 四个 LLM 分析节点使用 LangGraph 子图 **并发执行**，单板块失败不影响其他板块。

## 业务术语

| 术语 | 定义 | 处理方式 |
|------|------|---------|
| **呆滞件** | 有效库存 > 0，90天出库数 = 0 | 不做计划 |
| **低频件** | 月均销量 < 1 或 出库次数 < 3 或 出库间隔 ≥ 30天 | 不做计划 |
| **缺货件** | 有效库存 = 0，月均销量 ≥ 1 | 需要补货 |
| **正常件** | 不属于以上三类 | 按需补货 |

## 项目结构

```
fw-pms-ai/
├── src/fw_pms_ai/
│   ├── main.py                     # 应用入口
│   ├── agent/                      # LangGraph Agent 工作流
│   │   ├── state.py                # Agent 状态定义 (TypedDict + Annotated reducer)
│   │   ├── nodes.py                # 工作流节点 (fetch/sql_agent/allocate)
│   │   ├── analysis_report_node.py # 分析报告节点 (统计计算 + 并发 LLM 子图)
│   │   ├── replenishment.py        # ReplenishmentAgent 主类 (构建图 + 运行)
│   │   └── sql_agent/              # SQL Agent 子包
│   │       ├── agent.py            # SQLAgent 主类
│   │       ├── executor.py         # SQL 执行器
│   │       ├── analyzer.py         # 配件分析器 (逐配件 LLM 分析)
│   │       └── prompts.py          # 提示词加载
│   ├── api/                        # FastAPI REST API
│   │   ├── app.py                  # FastAPI 应用 (CORS + 静态文件 + 路由)
│   │   └── routes/
│   │       └── tasks.py            # 任务/明细/日志/汇总/报告 API
│   ├── config/
│   │   └── settings.py             # Pydantic Settings 配置管理
│   ├── llm/                        # LLM 适配层
│   │   ├── base.py                 # BaseLLMClient 抽象基类
│   │   ├── glm.py                  # 智谱 GLM 客户端
│   │   ├── doubao.py               # 豆包客户端
│   │   ├── openai_compat.py        # OpenAI 兼容客户端 (火山引擎等)
│   │   └── anthropic_compat.py     # Anthropic 兼容客户端
│   ├── models/                     # 数据模型 (Pydantic)
│   │   ├── task.py                 # 任务模型 + 状态枚举
│   │   ├── suggestion.py           # 补货建议模型
│   │   ├── part_ratio.py           # 配件库销比模型
│   │   ├── part_summary.py         # 配件汇总模型
│   │   ├── analysis_report.py      # 分析报告模型
│   │   ├── execution_log.py        # 执行日志模型
│   │   └── sql_result.py           # SQL 执行结果模型
│   ├── services/                   # 业务服务层
│   │   ├── db.py                   # 数据库连接管理
│   │   ├── data_service.py         # 数据查询服务
│   │   ├── result_writer.py        # 结果写入服务
│   │   └── repository/             # 仓库模式
│   │       ├── task_repo.py        # 任务仓库
│   │       ├── detail_repo.py      # 明细仓库
│   │       └── log_repo.py         # 日志仓库
│   └── scheduler/
│       └── tasks.py                # APScheduler 定时任务 + CLI 参数解析
├── prompts/                        # AI 提示词文件
│   ├── sql_agent.md                # SQL Agent 系统提示词
│   ├── suggestion.md               # 补货建议生成提示词
│   ├── suggestion_system.md        # 补货建议系统提示词
│   ├── part_shop_analysis.md       # 配件门店分析提示词
│   ├── part_shop_analysis_system.md
│   ├── report_inventory_overview.md  # 分析报告-库存概览提示词
│   ├── report_sales_analysis.md      # 分析报告-销量分析提示词
│   ├── report_inventory_health.md    # 分析报告-库存健康度提示词
│   └── report_replenishment_summary.md # 分析报告-补货建议提示词
├── ui/                             # 前端静态文件
│   ├── index.html                  # 主页面
│   ├── css/                        # 样式
│   ├── js/                         # JavaScript
│   └── merchant-report/            # 商家组合报告页面
├── sql/                            # 数据库脚本
│   ├── init.sql                    # 初始化建表 (4张表)
│   └── migrate_analysis_report.sql # 分析报告表迁移
├── docs/                           # 文档
│   ├── architecture.md             # 系统架构文档
│   └── 商家组合维度分析需求设计.md
├── pyproject.toml                  # 项目配置 (hatchling 构建)
├── .env                            # 环境变量
└── README.md
```

## 数据表说明

| 表名 | 说明 | SQL 文件 |
|------|------|---------|
| `part_ratio` | 配件库销比数据（来源表，只读） | — |
| `ai_replenishment_task` | 任务记录 | init.sql |
| `ai_replenishment_detail` | 配件级别补货建议明细 | init.sql |
| `ai_replenishment_part_summary` | 配件汇总表（按配件编码聚合） | init.sql |
| `ai_task_execution_log` | 任务执行日志（每步骤详情） | init.sql |
| `ai_analysis_report` | 结构化分析报告（四大板块 JSON） | migrate_analysis_report.sql |

## API 接口

基于 FastAPI 提供 REST API，支持前端 UI 对接。

| 方法 | 路径 | 说明 |
|------|------|------|
| GET | `/api/tasks` | 任务列表（分页、状态/组合/日期筛选） |
| GET | `/api/tasks/{task_no}` | 任务详情 |
| GET | `/api/tasks/{task_no}/details` | 配件建议明细（分页、排序、搜索） |
| GET | `/api/tasks/{task_no}/logs` | 执行日志 |
| GET | `/api/tasks/{task_no}/part-summaries` | 配件汇总列表（分页、优先级筛选） |
| GET | `/api/tasks/{task_no}/parts/{part_code}/shops` | 指定配件的门店明细 |
| GET | `/api/tasks/{task_no}/analysis-report` | 分析报告 |
| GET | `/health` | 健康检查 |
| GET | `/` | 主页面（静态文件） |

运行后访问 `/docs` 查看 Swagger 文档。

## LLM 集成

支持 4 种 LLM 客户端，通过环境变量自动选择：

| 客户端 | 环境变量 | 说明 |
|--------|---------|------|
| `OpenAICompatClient` | `OPENAI_COMPAT_API_KEY` | OpenAI 兼容接口（火山引擎、智谱等） |
| `AnthropicCompatClient` | `ANTHROPIC_API_KEY` | Anthropic 兼容接口 |
| `GLMClient` | `GLM_API_KEY` | 智谱 GLM 原生 SDK |
| `DoubaoClient` | `DOUBAO_API_KEY` | 豆包 |

优先级：`OpenAI Compat` > `Anthropic Compat` > `GLM` > `Doubao`

## 快速开始

### 1. 安装依赖

```bash
cd fw-pms-ai
pip install -e .
```

### 2. 配置环境变量

```bash
cp .env.example .env
# 编辑 .env 填写以下配置
```

必填配置项：

```env
# LLM (至少配置一种)
OPENAI_COMPAT_API_KEY=your-key
OPENAI_COMPAT_BASE_URL=https://ark.cn-beijing.volces.com/api/v3
OPENAI_COMPAT_MODEL=glm-4-7-251222

# 数据库
MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_USER=root
MYSQL_PASSWORD=your-password
MYSQL_DATABASE=fw_pms
```

### 3. 初始化数据库

```bash
# 基础表结构
mysql -u root -p fw_pms < sql/init.sql

# 分析报告表
mysql -u root -p fw_pms < sql/migrate_analysis_report.sql
```

### 4. 运行

```bash
# 启动定时任务调度器（默认每日 02:00 执行）
fw-pms-ai

# 立即执行一次（所有商家组合）
fw-pms-ai --run-once

# 指定集团和商家组合
fw-pms-ai --run-once --group-id 2 --dealer-grouping-id 100
```

### 5. 启动 API 服务

```bash
uvicorn fw_pms_ai.api.app:app --host 0.0.0.0 --port 8000 --reload
```

## 开发

```bash
# 安装开发依赖
pip install -e ".[dev]"

# 代码格式化
black src/
ruff check src/

# 运行测试
pytest tests/ -v
```

## 提示词文件

提示词文件存放在 `prompts/` 目录，供 LLM 调用时使用：

| 文件 | 用途 |
|------|------|
| `sql_agent.md` | SQL Agent 生成 SQL 查询的系统提示词 |
| `suggestion.md` | 配件补货建议生成 |
| `suggestion_system.md` | 补货建议系统角色提示词 |
| `part_shop_analysis.md` | 配件门店级别分析 |
| `part_shop_analysis_system.md` | 门店分析系统角色提示词 |
| `report_inventory_overview.md` | 分析报告 — 库存概览板块 |
| `report_sales_analysis.md` | 分析报告 — 销量分析板块 |
| `report_inventory_health.md` | 分析报告 — 库存健康度板块 |
| `report_replenishment_summary.md` | 分析报告 — 补货建议板块 |
