# 实现计划：重构分析报告功能

## 概述

全栈重构分析报告功能，从清理现有代码开始，依次重建数据库表、数据模型、统计计算、LLM 提示词、并发节点、API 接口、前端页面。使用 Python + LangGraph + FastAPI + Chart.js 技术栈。

## 任务

- [x] 1. 清理现有分析报告专属文件
  - [x] 1.1 清空 `src/fw_pms_ai/models/analysis_report.py`，仅保留文件头注释和必要 import，移除现有 AnalysisReport dataclass 的所有字段和方法
  - [x] 1.2 清空 `src/fw_pms_ai/agent/analysis_report_node.py`，仅保留文件头注释和必要 import，移除 `_load_prompt`、`_calculate_suggestion_stats`、`_calculate_risk_stats`、`_build_suggestion_summary`、`generate_analysis_report_node` 等所有函数
  - [x] 1.3 清空 `prompts/analysis_report.md` 的内容
  - 注意：此步骤仅清理分析报告专属文件，不修改 `tasks.py`、`app.js`、`result_writer.py` 等共享文件（这些文件中的报告相关代码将在后续重建步骤中以替换方式更新）
  - _Requirements: 1.1, 1.2, 1.3, 1.5_

- [x] 2. 重建数据库表和数据模型
  - [x] 2.1 重写 `sql/migrate_analysis_report.sql`，创建新表结构（inventory_overview、sales_analysis、inventory_health、replenishment_summary 四个 JSON 字段 + LLM 元数据字段）
    - _Requirements: 6.1, 6.2, 6.3, 6.4, 6.5_
  - [x] 2.2 在已清空的 `src/fw_pms_ai/models/analysis_report.py` 中编写新的 AnalysisReport dataclass（四个 Dict 字段 + to_dict 方法）
    - _Requirements: 10.1, 10.3_
  - [x] 2.3 替换 `src/fw_pms_ai/services/result_writer.py` 中的 `save_analysis_report` 方法为新版本，适配新表结构（四个 JSON 字段序列化写入），不修改该文件中的其他方法
    - _Requirements: 10.2_
  - [ ]* 2.4 编写属性测试：报告数据模型序列化 round-trip
    - **Property 5: 报告数据模型序列化 round-trip**
    - **Validates: Requirements 10.2, 10.3**

- [x] 3. 实现四大板块统计计算函数
  - [x] 3.1 在已清空的 `src/fw_pms_ai/agent/analysis_report_node.py` 中实现 `calculate_inventory_overview(part_ratios)` 函数
    - 计算有效库存（valid_storage_cnt = in_stock_unlocked_cnt + on_the_way_cnt + has_plan_cnt）总数量/总金额、三项构成明细、库销比
    - _Requirements: 2.1, 2.2, 2.3, 2.5_
  - [x] 3.2 实现 `calculate_sales_analysis(part_ratios)` 函数
    - 计算月均销量总数量/总金额、各组成部分（out_stock_cnt/storage_locked_cnt/out_stock_ongoing_cnt/buy_cnt）总量、有销量/无销量配件数
    - _Requirements: 3.1, 3.2, 3.4_
  - [x] 3.3 实现 `calculate_inventory_health(part_ratios)` 函数
    - 将配件分类为缺货/呆滞/低频/正常，计算各类型数量/金额/百分比，生成 chart_data
    - _Requirements: 4.1, 4.2_
  - [x] 3.4 实现 `calculate_replenishment_summary(part_results)` 函数
    - 按优先级（1=急需/2=建议/3=可选）统计配件种类数和金额
    - _Requirements: 5.1, 5.2_
  - [ ]* 3.5 编写属性测试：库存概览统计一致性
    - **Property 1: 库存概览统计一致性**
    - **Validates: Requirements 2.1, 2.2, 2.3**
  - [ ]* 3.6 编写属性测试：销量分析统计一致性
    - **Property 2: 销量分析统计一致性**
    - **Validates: Requirements 3.1, 3.2, 3.4**
  - [ ]* 3.7 编写属性测试：健康度分类完备性与一致性
    - **Property 3: 健康度分类完备性与一致性**
    - **Validates: Requirements 4.1, 4.2**
  - [ ]* 3.8 编写属性测试：补货建议统计一致性
    - **Property 4: 补货建议统计一致性**
    - **Validates: Requirements 5.1, 5.2**

- [ ] 4. Checkpoint - 确保统计计算函数和属性测试通过
  - 确保所有测试通过，如有问题请向用户确认。

- [x] 5. 创建 LLM 提示词文件
  - [x] 5.1 创建 `prompts/report_inventory_overview.md`，包含库存概览分析提示词（资金占用评估、库销比诊断、库存结构建议），确保分析专业且有实际决策价值
    - _Requirements: 7.2_
  - [x] 5.2 创建 `prompts/report_sales_analysis.md`，包含销量分析提示词（销量构成解读、销售活跃度、需求趋势判断），确保分析专业且有实际决策价值
    - _Requirements: 7.2_
  - [x] 5.3 创建 `prompts/report_inventory_health.md`，包含健康度分析提示词（健康度评分、问题诊断、资金释放机会、改善优先级），确保分析专业且有实际决策价值
    - _Requirements: 7.2_
  - [x] 5.4 创建 `prompts/report_replenishment_summary.md`，包含补货建议分析提示词（紧迫度评估、资金分配建议、执行节奏、风险提示），确保分析专业且有实际决策价值
    - _Requirements: 7.2_
  - [x] 5.5 删除旧的 `prompts/analysis_report.md` 文件（已在步骤1.3清空，此处正式删除）
    - _Requirements: 1.3_

- [x] 6. 实现 LangGraph 并发 LLM 分析节点
  - [x] 6.1 在 `src/fw_pms_ai/agent/analysis_report_node.py` 中实现四个 LLM 分析函数（`llm_analyze_inventory_overview`、`llm_analyze_sales`、`llm_analyze_inventory_health`、`llm_analyze_replenishment_summary`），每个函数加载对应提示词、填充统计数据、调用 LLM、解析 JSON 响应
    - _Requirements: 7.2, 7.3_
  - [x] 6.2 使用 LangGraph StateGraph 构建并发子图，四个 LLM 节点从 START fan-out 并发执行，结果 fan-in 汇总
    - _Requirements: 7.1, 7.4_
  - [x] 6.3 实现新的 `generate_analysis_report_node(state)` 主函数，串联统计计算 → 并发 LLM 分析 → 汇总报告 → 写入数据库，单板块 LLM 失败不影响其他板块
    - _Requirements: 7.4, 7.5_
  - [x] 6.4 确认 `src/fw_pms_ai/agent/replenishment.py` 中的工作流引用无需修改（`generate_analysis_report_node` 函数签名保持不变）
    - _Requirements: 7.1_

- [ ] 7. Checkpoint - 确保后端报告生成流程完整
  - 确保所有测试通过，如有问题请向用户确认。

- [x] 8. 重建 API 接口
  - [x] 8.1 替换 `src/fw_pms_ai/api/routes/tasks.py` 中的 `AnalysisReportResponse` 模型为新版本（inventory_overview、sales_analysis、inventory_health、replenishment_summary 四个 Dict 字段），不修改该文件中的其他模型和端点
    - _Requirements: 8.1_
  - [x] 8.2 替换 `get_analysis_report` 端点实现，从新表读取数据并解析 JSON 字段，不修改该文件中的其他端点
    - _Requirements: 8.1, 8.2, 8.3_

- [x] 9. 重建前端报告页面
  - [x] 9.1 在 `ui/index.html` 中引入 Chart.js CDN
    - _Requirements: 9.6_
  - [x] 9.2 替换 `ui/js/app.js` 中的 `renderReportTab` 方法为新版本，渲染四大板块框架，同时移除旧的 `renderOverallAssessment`、`renderRiskAlerts`、`renderStrategy`、`renderExpectedImpact` 方法，不修改该文件中的其他方法
    - _Requirements: 9.1, 1.4_
  - [x] 9.3 实现 `renderInventoryOverview` 方法，渲染库存概览板块（统计卡片 + 五项构成明细 + LLM 分析文本）
    - _Requirements: 9.2_
  - [x] 9.4 实现 `renderSalesAnalysis` 方法，渲染销量分析板块（统计卡片 + 构成明细 + LLM 分析文本）
    - _Requirements: 9.3_
  - [x] 9.5 实现 `renderInventoryHealth` 方法，渲染健康度板块（统计卡片 + Chart.js 环形图 + LLM 分析文本）
    - _Requirements: 9.4, 9.6_
  - [x] 9.6 实现 `renderReplenishmentSummary` 方法，渲染补货建议板块（优先级统计表 + LLM 分析文本）
    - _Requirements: 9.5_
  - [x] 9.7 在 `ui/css/style.css` 中添加新报告板块的样式（统计卡片、图表容器、分析文本区域），不修改现有样式
    - _Requirements: 9.1_

- [ ] 10. Final Checkpoint - 全栈集成验证
  - 确保所有测试通过，如有问题请向用户确认。

## 安全约束：不影响补货建议功能

本次重构严格限定在分析报告模块范围内，以下补货建议相关代码禁止修改：

- `src/fw_pms_ai/agent/nodes.py` — 补货建议核心节点（fetch_part_ratio、sql_agent、allocate_budget）
- `src/fw_pms_ai/agent/replenishment.py` — 补货建议工作流（仅确认无需修改，不做任何改动）
- `src/fw_pms_ai/agent/sql_agent/` — SQL Agent 目录
- `src/fw_pms_ai/models/part_ratio.py` — 配件库销比模型
- `src/fw_pms_ai/models/replenishment_*.py` — 补货建议相关模型
- `result_writer.py` 中的 `save_task`、`update_task`、`save_details`、`save_part_summaries`、`save_execution_log` 等方法
- `tasks.py` 中的任务列表、任务详情、配件明细、配件汇总、执行日志等端点
- `app.js` 中的任务列表、任务详情、配件明细等渲染方法
- `prompts/` 中的 `part_shop_analysis*.md`、`suggestion*.md`、`sql_agent.md` 等提示词文件

## 备注

- 标记 `*` 的任务为可选任务，可跳过以加快 MVP 进度
- 每个任务引用了具体的需求编号以保证可追溯性
- 属性测试使用 `hypothesis` 库，每个属性至少 100 次迭代
- Checkpoint 用于阶段性验证，确保增量正确
- 共享文件（tasks.py、app.js、result_writer.py、style.css）中的修改均采用"替换特定函数/类"方式，明确不修改其他部分
